import java.util.concurrent.*;

class PublisherVT {
	public static void main(String[] args) throws InterruptedException {
		long start = System.currentTimeMillis();
		try (ExecutorService es = Executors.newVirtualThreadPerTaskExecutor();
			var publisher = new SubmissionPublisher<Integer>(es, 256)) {
			for (int i = 1; i < 10_000; i++)
				publisher.subscribe(new DemoSubscriber());
			for (int i = 1; i <= 5; i++)
				publisher.submit(i);
		}
		System.out.println("Benötigte Zeit in ms mit virtuellen Threads: " + (System.currentTimeMillis() - start));
	}
}